<?php
/** 
 * Blazin Customizer data
 */

function blazin_customizer( $data ) {
	$blazin_elementor_template_list = blazin_get_elementor_templates();
	return array(
		'panel' => array ( 
			'id' => 'blazin',
			'name' => esc_html__('Blazin Customizer','blazin'),
			'priority' => 10,
			'section' => array(
				'header_setting' => array(
					'name' => esc_html__( 'Header Topbar Setting', 'blazin' ),
					'priority' => 10,
					'fields' => array(
						array(
							'name' => esc_html__( 'Topbar Swicher', 'blazin' ),
							'id' => 'blazin_topbar_switch',
							'default' => false,
							'type' => 'switch',
							'transport'	=> 'refresh'
						),						
						array(
							'name' => esc_html__( 'Show Button', 'blazin' ),
							'id' => 'blazin_show_header_btn',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Text', 'blazin' ),
							'id' => 'blazin_header_btn_text',
							'default' => esc_html__('Sign in','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Link', 'blazin' ),
							'id' => 'blazin_header_btn_link',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Button Icon', 'blazin' ),
							'id' => 'blazin_header_btn_icon',
							'default' => esc_html__('fa fa-user-o', 'blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						/** investment button **/	
						array(
							'name' => esc_html__( 'Show Investment Offer Link', 'blazin' ),
							'id' => 'blazin_show_investment_offer_link',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Link Text', 'blazin' ),
							'id' => 'blazin_header_link_text',
							'default' => esc_html__('Blazin Offer','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Link Url', 'blazin' ),
							'id' => 'blazin_header_link_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						/** contact-info **/
						array(
							'name' => esc_html__( 'Show Contact Info', 'blazin' ),
							'id' => 'blazin_show_contact_info',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Email Address', 'blazin' ),
							'id' => 'blazin_header_email',
							'default' => esc_html__('info@gmail.com','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Phone Number', 'blazin' ),
							'id' => 'blazin_header_phone',
							'default' => esc_html__('+97657945737', 'blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						)

					) 
				),
				'blazin_topbar_social_profiles_setting' => array(
					'name' => esc_html__( 'Header Social Profiles', 'blazin' ),
					'priority' => 15,
					'fields' => array(
						array(
							'name' => esc_html__( 'Show Social Profiles', 'blazin' ),
							'id' => 'blazin_show_social_profiles',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Facebook Url', 'blazin' ),
							'id' => 'blazin_topbar_fb_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Twitter Url', 'blazin' ),
							'id' => 'blazin_topbar_twitter_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Linkedin Url', 'blazin' ),
							'id' => 'blazin_topbar_linkedin_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Instagram Url', 'blazin' ),
							'id' => 'blazin_topbar_instagram_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
					) 
				),
				'header_main_setting' => array(
					'name' => esc_html__( 'Header Setting', 'blazin' ),
					'priority' => 20,
					'fields' => array(
						array(
							'name' => esc_html__( 'Choose Header Style', 'blazin' ),
							'id' => 'choose_default_header',
							'type'     => 'select',
							'choices'  => array(
								'header-style-1' => esc_html__( 'Header Style 1', 'blazin' ),
								'header-style-2' => esc_html__( 'Header Style 2', 'blazin' ),
							),
							'default' => 'header-style-2',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Header Logo', 'blazin' ),
							'id' => 'logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Black Logo', 'blazin' ),
							'id' => 'seconday_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo-black.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Retina Logo', 'blazin' ),
							'id' => 'retina_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo@2x.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Retina Black Logo', 'blazin' ),
							'id' => 'retina_secondary_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo-black@2x.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Show Header Search', 'blazin' ),
							'id' => 'blazin_header_search_show',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
					) 
				),	
				'page_title_setting'=> array(
					'name'=> esc_html__('Page Title Setting','blazin'),
					'priority'=> 30,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Choose Breadcrumb Style', 'blazin' ),
							'id' => 'choose_default_breadcrumb',
							'type'     => 'select',
							'choices'  => array(
								'breadcrumb-style-1' => esc_html__( 'Breadcrumb Style 1', 'blazin' ),
								'breadcrumb-style-2' => esc_html__( 'default', 'blazin' ),
							),
							'default' => 'breadcrumb-style-1',
							'transport'	=> 'refresh'
						),
						array(
							'name'=>esc_html__('Breadcrumb BG Color','blazin'),
							'id'=>'breadcrumb_bg_color',
							'default'=> esc_html__('#343a40','blazin'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Page Title Background Image', 'blazin' ),
							'id' => 'breadcrumb_bg_img',
							'default' => '',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb Archive', 'blazin' ),
							'id' => 'breadcrumb_archive',
							'default' => esc_html__('Archive for category','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb Search', 'blazin' ),
							'id' => 'breadcrumb_search',
							'default' => esc_html__('Search results for','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb tagged', 'blazin' ),
							'id' => 'breadcrumb_post_tags',
							'default' => esc_html__('Posts tagged','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb posted by', 'blazin' ),
							'id' => 'breadcrumb_artitle_post_by',
							'default' => esc_html__('Articles posted by','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb Page Not Found', 'blazin' ),
							'id' => 'breadcrumb_404',
							'default' => esc_html__('Page Not Found','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb Page', 'blazin' ),
							'id' => 'breadcrumb_page',
							'default' => esc_html__('Page','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),			
						array(
							'name' => esc_html__( 'Breadcrumb Shop', 'blazin' ),
							'id' => 'breadcrumb_shop',
							'default' => esc_html__('Shop','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),			
						array(
							'name' => esc_html__( 'Breadcrumb Home', 'blazin' ),
							'id' => 'breadcrumb_home',
							'default' => esc_html__('Home','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),					
					)
				),
				'blog_setting'=> array(
					'name'=> esc_html__('Blog Setting','blazin'),
					'priority'=> 40,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Show Blog BTN', 'blazin' ),
							'id' => 'blazin_blog_btn_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Show Blog Btn Icon', 'blazin' ),
							'id' => 'blazin_blog_btn_icon_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Blog Button text', 'blazin' ),
							'id' => 'blazin_blog_btn',
							'default' => esc_html__('Read More','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),							
						array(
							'name' => esc_html__( 'Blog Button Icon', 'blazin' ),
							'id' => 'blazin_blog_btn_icon',
							'default' => esc_html__('fas fa-angle-double-right','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Title', 'blazin' ),
							'id' => 'breadcrumb_blog_title',
							'default' => esc_html__('Blog','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Details Title', 'blazin' ),
							'id' => 'breadcrumb_blog_title_details',
							'default' => esc_html__('Blog Details','blazin'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),

					)
				),
				'blazin_footer_setting' => array(
					'name'=> esc_html__('Footer Setting','blazin'),
					'priority'=> 60,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Footer Elementor Templates', 'blazin' ),
							'id' => 'choose_elementor_footer',
							'type'     => 'select',
							'choices'  => $blazin_elementor_template_list,
							'transport'	=> 'refresh',
							'required' => ['footer_source_type',
							'=',
							'e'],
						),
						array(
							'name' => esc_html__( 'Choose Footer Style', 'blazin' ),
							'id' => 'choose_default_footer',
							'type'     => 'select',
							'choices'  => array(
								'footer-style-1' => esc_html__( 'Footer Style 1', 'blazin' ),
								'footer-style-2' => esc_html__( 'Footer Style 2', 'blazin' ),
								'footer-style-3' => esc_html__( 'Footer Style 3', 'blazin' ),
							),
							'default' => 'footer-style-1',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Footer Background Image', 'blazin' ),
							'id' => 'blazin_footer_bg',
							'default' => '',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name'=>esc_html__('Footer BG Color','blazin'),
							'id'=>'blazin_footer_bg_color',
							'default'=> esc_html__('#f4f9fc','blazin'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Copy Right','blazin'),
							'id'=>'blazin_copyright',
							'default'=> esc_html__('Copyright &copy; Blazin 2023. All rights reserved','blazin'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),	
						array(
							'name'=>esc_html__('Enable Scrollup','blazin'),
							'id'=>'blazin_scrollup_switch',
							'default'=> false,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						),						
						array(
							'name'=>esc_html__('Enable Footer Widgets','blazin'),
							'id'=>'blazin_enable_footer_widgets',
							'default'=> true,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						),	
						array(
							'name'=>esc_html__('Enable Preloader','blazin'),
							'id'=>'blazin_preloader_switch',
							'default'=> false,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						)
					)
				),
				'error_page_setting'=> array(
					'name'=> esc_html__('404 Setting','blazin'),
					'priority'=> 90,
					'fields'=> array(
						array(
							'name'=>esc_html__('400 Text','blazin'),
							'id'=>'blazin_error_404_text',
							'default'=> esc_html__('404','blazin'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Not Found Title','blazin'),
							'id'=>'blazin_error_title',
							'default'=> esc_html__('Page not found','blazin'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Description Text','blazin'),
							'id'=>'blazin_error_desc',
							'default'=> esc_html__('Oops! The page you are looking for does not exist. It might have been moved or deleted','blazin'),
							'type'=>'textarea',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Link Text','blazin'),
							'id'=>'blazin_error_link_text',
							'default'=> esc_html__('Back To Home','blazin'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						)
						
					)
				),
			),
		)
	);

}

add_filter('blazin_customizer_data', 'blazin_customizer');


