<?php
/**
 * blazin functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package blazin
 */
 
/**
 * Define Const for theme Dir
 * @since 1.0.0
 * */
define('BLAZIN_ROOT_PATH',get_template_directory());
define('BLAZIN_ROOT_URL',get_template_directory_uri());
define('BLAZIN_CSS',BLAZIN_ROOT_URL .'/assets/css');
define('BLAZIN_JS',BLAZIN_ROOT_URL .'/assets/js');
define('BLAZIN_IMG',BLAZIN_ROOT_URL .'/assets/img');
define('BLAZIN_INC',BLAZIN_ROOT_PATH .'/inc');
define('BLAZIN_THEME_STYLESHEETS',BLAZIN_INC .'/theme-stylesheets');

/**
 * define theme info
 * @since 1.0.0
 * */
if (is_child_theme()){
	$theme = wp_get_theme();
	$parent_theme = $theme->Template;
	$theme_info = wp_get_theme($parent_theme);
}else{
	$theme_info = wp_get_theme();
}
define('BLAZIN_DEV_MODE',true);
$gazania_version = BLAZIN_DEV_MODE ? time() : $theme_info->get('Version');
define('BLAZIN_NAME',$theme_info->get('Name'));
define('BLAZIN_VERSION',$gazania_version);
define('BLAZIN_AUTHOR',$theme_info->get('Author'));
define('BLAZIN_AUTHOR_URI',$theme_info->get('AuthorURI'));

/*
 * include template helper function
 * @since 1.0.0
 * */
if (file_exists(BLAZIN_INC.'/template-functions.php') && BLAZIN_INC.'/template-tags.php'){
	require_once  BLAZIN_INC.'/template-functions.php';
	require_once  BLAZIN_INC.'/template-tags.php';

	function Blazin_Function($instance){
		$new_instance = false;
		switch ($instance){
			case ("Functions"):
				$new_instance = class_exists('Blazin_Functions') ? Blazin_Functions::getInstance() : false;
				break;
			case ("Tags"):
				$new_instance = class_exists('Blazin_Tags') ? Blazin_Tags::getInstance() : false;
				break;
			default:
				 $new_instance = false;
			break;
		}

		return $new_instance;
	}
}



/*
* Include theme init file
* @since 1.0.0
*/
if ( file_exists(BLAZIN_INC.'/class-blazin-init.php' ) ) {
	require_once  BLAZIN_INC.'/class-blazin-init.php';
}

if ( file_exists(BLAZIN_INC.'/plugins/tgma/activate.php') ) {
	require_once  BLAZIN_INC.'/plugins/tgma/activate.php';
}		

/**
 * Custom template helper function for this theme.
 */
require_once BLAZIN_INC . '/template-helper.php';
require_once BLAZIN_INC . '/blazin_customizer.php';
require_once BLAZIN_INC . '/blazin_customizer_data.php';



// Move comments textarea to bottom
function gazania_move_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}
add_filter( 'comment_form_fields', 'gazania_move_comment_field_to_bottom' );


/**
 * Nav menu fallback function
 * @since 1.0.0
 */
 function blazin_primary_menu_fallback()
{
    get_template_part('template-parts/default', 'menu');
}


function blazin_block_editor_styles() {
	wp_enqueue_style( 'block-editor-bootstrap', get_theme_file_uri( 'assets/css/block-editor.bootstrap.css' ), array(), null );
	wp_enqueue_style( 'block-editor-theme', get_theme_file_uri( 'assets/css/block-editor.theme.css' ), array(), null );
}
add_action( 'enqueue_block_editor_assets', 'blazin_block_editor_styles', 1, 1 );

/**
* admin js
**/
add_action('admin_enqueue_scripts', 'blazin_admin_custom_scripts');
function blazin_admin_custom_scripts(){
	wp_enqueue_media();
	wp_register_script('blazin-admin-custom', get_template_directory_uri().'/inc/js/admin_custom.js', array('jquery'), '', true);
	wp_enqueue_script('blazin-admin-custom');
}


/**
* shortcode supports for removing extra p, spance etc
*
*/
add_filter( 'the_content', 'blazin_shortcode_extra_content_remove' );
/**
 * Filters the content to remove any extra paragraph or break tags
 * caused by shortcodes.
 *
 * @since 1.0.0
 *
 * @param string $content  String of HTML content.
 * @return string $content Amended string of HTML content.
 */
function blazin_shortcode_extra_content_remove( $content ) {

    $array = array(
        '<p>['    => '[',
        ']</p>'   => ']',
        ']<br />' => ']'
    );
    return strtr( $content, $array );

}


/**
 * Nav menu fallback function
 * @since 1.0.0
 */
 function blazin_theme_fallback_menu()
{
    get_template_part('template-parts/default', 'menu');
}


/**
 * Blazin CSS Include
 */
function enqueue_our_required_stylesheet(){
	wp_enqueue_style('load-fa-pro', get_template_directory_uri(). '/assets/fonts/fontawesome-pro-v5.css');
	wp_enqueue_style('load-fa', get_template_directory_uri(). '/assets/fonts/fontawesome-v6.css');
	wp_enqueue_style('roboto-font', get_template_directory_uri() . '/assets/fonts/roboto.css' );
	wp_enqueue_style('blazin-owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.min.css' );
	$rtl_class = get_body_class();
	if(in_array('rtl',$rtl_class)){
		wp_enqueue_style('blazin-style-css', get_template_directory_uri() . '/assets/css/blazin-rtl.css' );
	}
	else{
		wp_enqueue_style('blazin-style-css', get_template_directory_uri() . '/assets/css/blazin.css' ); 
	}
	wp_enqueue_style('blazin-responsive-css', get_template_directory_uri() . '/assets/css/blazin-responsive.css' ); 
}
add_action( 'wp_enqueue_scripts', 'enqueue_our_required_stylesheet' );


/**
 * Blazin CSS Include In Footer
 */
function add_css_in_footer() {
	$rtl_class = get_body_class();
	if(in_array('rtl', $rtl_class)) {
		?>
		<link rel="stylesheet" href="<?php echo get_template_directory_uri() . '/assets/css/style-rtl.css'?>" type="text/css" media="all">
		<?php
	}
	else {
		?>
		<link rel="stylesheet" href="<?php echo get_template_directory_uri() . '/assets/css/style.css'?>" type="text/css" media="all">
		<?php
	}
		?>
	<link rel="stylesheet" href="<?php echo get_template_directory_uri() . '/assets/css/responsive.css'?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri() . '/assets/css/style.css'?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri() . '/assets/css/responsive.css'?>" type="text/css" media="all">
	<?php
}
add_action( 'wp_footer', 'add_css_in_footer', 100 );

function enqueue_theme_styles() { 
	wp_register_style( 'header-style', BLAZIN_CSS . '/style.css', array(), time(), 'all' ); 
	wp_register_style( 'responsive', BLAZIN_CSS . '/responsive.css', array(), time(), 'all' ); 
	
	wp_enqueue_style( 'header-style' ); 
	wp_enqueue_style( 'responsive' ); 
	} 
	add_action( 'wp_enqueue_scripts', 'enqueue_theme_styles' );



/**
 * Blazin JS Include
 */
function enqueue_load_js() {
	if ( is_page( array( 'vps-servers' ) )) {
        wp_enqueue_script( 'jquery-1.8.3', get_template_directory_uri() . '/assets/js/jquery-1.8.3.js', array(), '1.0.0', true );
    }
	wp_enqueue_script( 'jquery-1.8.3', get_template_directory_uri() . '/assets/js/jquery-1.8.3.js', array(), '1.0.0', true );
	wp_enqueue_script( 'jquery.cycle.all', get_template_directory_uri() . '/assets/js/jquery.cycle.all.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'jquery.slicknav', get_template_directory_uri() . '/assets/js/jquery.slicknav.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'slider', get_template_directory_uri() . '/assets/js/slider.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'custom.min', get_template_directory_uri() . '/assets/js/jquery-ui-1.9.2.custom.min.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'effects.core', get_template_directory_uri() . '/assets/js/jquery.effects.core.min.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'scripts', get_template_directory_uri() . '/assets/js/scripts.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'owl_crousel1', get_template_directory_uri() . '/assets/js/owl.carousel.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'owl_crousel_min', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'carousel', get_template_directory_uri() . '/assets/js/carousel.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'custom-js', get_template_directory_uri() . '/assets/js/custom.js', array( 'jquery' ), '', true );
	wp_localize_script( 'custom', 'BlazinAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ),'HOME_URL'=> home_url() ));  
}
add_action( 'wp_enqueue_scripts', 'enqueue_load_js' );

/**
 * Function For Elementor Global Colors after import.
 */
add_action('akd_elementor_global', 'blazin_elementor_global_setup');
function blazin_elementor_global_setup()
{
    $blazin_elementor_kit = apply_filters('blazin_elementor_global', false);
    if ($blazin_elementor_kit)
    {
        esc_attr($blazin_elementor_kit);
    }
}

/**
 * Get Elementor Template list
 */
function blazin_get_elementor_templates()
{
    $args = array(
        'post_type' => 'elementor_library',
        'post_status' => 'publish',
    );
    $blazin_the_query = new WP_Query($args);
    $blazin_elementor_posts = array();
    if ($blazin_the_query->have_posts()):
        foreach ($blazin_the_query->posts as $blazin_post):
            $blazin_elementor_posts[$blazin_post->ID] = apply_filters('the_title', get_the_title($blazin_post));
        endforeach;
    endif;
    return $blazin_elementor_posts;
}

// Add support for featured image
add_theme_support( 'post-thumbnails' );

// Add product title in Woocoomerce single product
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
function woocommerce_template_single_title_custom()
{
    the_title( '<h3 class="product_title entry-title">',' </h3>' );
}
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title_custom', 5);