<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor services-box Widget.
 *
 * Elementor widget that uses the services-box control.
 *
 * @since 1.0.0
 */
class Elementor_Services_Box_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve services-box widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'services-box';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve services-box widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blazin Services Box', 'elementor-services-box-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve services-box widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	// public function get_icon() {
	// 	return 'eicon-carousel-loop';
	// }

	/**
	 * Register services-box widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
        
        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-services-box-control' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_services_box',
			[
				'label' => __( 'Number of Services', 'elementor-services-box-control' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 6, // Set a default value
				'min' => 1,
				'max' => 21,
				'step' => 1,
			]
			);
        $this->end_controls_section();
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Content', 'elementor-services-box-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]

        );
        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( 'Title Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services_section h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .services_section h3',
			]
		);
        $this->add_control(
            'text_color1',
            [
                'label' => esc_html__( 'Text Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services_section p' => 'color: {{VALUE}}',
                ],
            ]
        );$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_text',
				'selector' => '{{WRAPPER}} .services_section p',
			]
		);
		$this->add_control(
            'text_color2',
            [
                'label' => esc_html__( 'Button Text Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services_section a' => 'color: {{VALUE}}',
                ],
            ]
        );$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_button',
				'selector' => '{{WRAPPER}} .services_section a',
			]
		);
        $this->add_responsive_control(
            'box_align',
            [
                'label' => esc_html__( 'Alignment', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'textdomain' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'textdomain' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'textdomain' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .services_section .box'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background1',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .services_section .box',
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__( 'Padding', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .services_section .box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        
	}
	/**
	 * Render services-box widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$number_of_services_box = $settings['number_of_services_box'];
        ?>
        <?php
    	$args = array(
			'post_type' => 'our_services',
			'orderby' => 'ID',
			'post_status' => 'publish',
			'order' => 'ASC',
			'posts_per_page' => $number_of_services_box,
		);	
		$result = new WP_Query( $args );
		echo '<div class="services_section position-relative" id="digital_services">';
		if ( $result-> have_posts() ) {
			?>
			<?php
				echo '<div class="row" data-aos="fade-up">';
				$count=0;
			while ( $result->have_posts() ){ 
				
				$result->the_post();
				$url = wp_get_attachment_url( get_post_thumbnail_id(), "thumbnail" );
                $meta = get_post_meta(get_the_ID(),'post_thumbnail', true);
				?>
				<div class="col-lg-4 col-md-4 col-sm-6 col-12">
                    <div class="box">
                        <figure>
                            <img src="<?php echo $meta;?>" alt="" class="img-fluid">
                        </figure>
                        <h3><?php echo get_the_title(); ?></h3>
                        <p class="text-size-16"><?php echo wp_trim_words( get_the_content(), 19 ); ?></p>
                        <div class="btn_wrapper">
                            <a class="text-decoration-none" href="<?php echo get_post_permalink(); ?>">Read More<i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
				</div>
				<?php
        		$count++;
        		if ($count % 3 == 0) {
            	echo '</div><div class="row">';
        		}
            }   
			echo '</div>';
	    }
    
		echo '</div>';
		?>
    	
        <?php
		
	}

}
