<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor portfolio Widget.
 *
 * Elementor widget that uses the portfolio control.
 *
 * @since 1.0.0
 */
class Elementor_Portfolio_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve portfolio widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'portfolio';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve portfolio widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blazin Portfolio', 'elementor-portfolio-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve portfolio widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	// public function get_icon() {
	// 	return 'eicon-carousel-loop';
	// }

	/**
	 * Register portfolio widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
        
        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-portfolio-control' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_portfolios',
			[
				'label' => __( 'Number of Case Studies', 'elementor-portfolio-control' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 6, // Set a default value
				'min' => 1,
				'max' => 21,
				'step' => 1,
			]
			);
        $this->end_controls_section();
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Content', 'elementor-portfolio-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]

        );
        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( 'Title Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_box_content .portfolio_title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .portfolio_box_content .portfolio_title',
			]
		);
        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__( 'Alignment', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'textdomain' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'textdomain' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'textdomain' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_box_content .portfolio_title'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'text_color1',
            [
                'label' => esc_html__( 'Text Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio_box_content .mb-0' => 'color: {{VALUE}}',
                ],
            ]
        );$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_text',
				'selector' => '{{WRAPPER}} .portfolio_box_content .mb-0',
			]
		);
        $this->add_responsive_control(
            'content_align',
            [
                'label' => esc_html__( 'Alignment', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'textdomain' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'textdomain' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'textdomain' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .mb-0'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background1',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .portfolio_box_content',
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__( 'Padding', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio_box_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        //Background Control
		$this->start_controls_section(
			'background_section',
			[
				'label' => esc_html__( 'Background Overlay', 'elementor-testimonial-control' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background3',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .overlay',
			]
		);
		$this->end_controls_section();
        
	}
	/**
	 * Render portfolio widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$number_of_portfolios = $settings['number_of_portfolios'];
        ?>
        <?php
    	$args = array(
			'post_type' => 'portfolio',
			'orderby' => 'ID',
			'post_status' => 'publish',
			'order' => 'ASC',
			'posts_per_page' => $number_of_portfolios,
		);	
		$result = new WP_Query( $args );
		echo '<div class="our_portfolio_section position-relative">';
		if ( $result-> have_posts() ) {
			
			?>
			<?php
				echo '<div class="row">';
				$count=0;
			while ( $result->have_posts() ){ 
				
				$result->the_post();
				$url = wp_get_attachment_url( get_post_thumbnail_id(), "thumbnail" );
				$meta = get_post_meta(get_the_ID(),'post_thumbnail', true);
				?>
				<div class="col-lg-4 col-md-4 col-sm-6 col-12">
                    <div class="portfolio_box position-relative <?php echo esc_attr( $settings['alignment'] ); ?>">
                        <div class="portfolio_image_wrapper">
                            <figure class="mb-0">
                                <img src="<?php echo $meta;?>" alt="" class="img-fluid">
                            </figure>
                            <div class="overlay bottom-overlay">
                                <div class="box_hover_effect">
                                    <a href="<?php echo get_post_permalink(); ?>" target="_blank">
                                        <figure class="mb-0">
                                            <img src="<?php echo PLUGIN_BASE_URI. 'assets/images/portfolio_box_hover.png' ?>" alt="" class="img-fluid">
                                        </figure>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="portfolio_box_content">
                            <span class="portfolio_title"><?php echo get_the_title(); ?></span>
                            <p class="mb-0"><?php echo wp_trim_words( get_the_content(), 5 ); ?></p>
                        </div>
                    </div>
				</div>
				<?php
        		$count++;
        		if ($count % 3 == 0) {
            	echo '</div><div class="row">';
        		}
            }   
			echo '</div>';
	    }
		echo '</div>';
		?>
        <?php
		
	}

}
