<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor our-services Widget.
 *
 * Elementor widget that uses the our-services control.
 *
 * @since 1.0.0
 */
class Elementor_Our_Services_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve our-services widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'our-services';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve our-services widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blazin Services Carousel', 'elementor-our-services-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve our-services widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register our-services widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
			$this->start_controls_section(
				'color_section',
				[
					'label' => esc_html__( 'Color', 'elementor-our-services-control' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'text_color',
				[
					'label'     => esc_html__( 'Text Color', 'elementor-our-services-control' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'elementor-our-services-control' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} h3' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'button_color',
				[
					'label' => __( 'Button Color', 'elementor-our-services-control' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .our_services_section .box .btn_wrapper a' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_group_control(
                \Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'background3',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .our_services_section .box',
                ]
            );
            // $this->add_control(
			// 	'alignment3',
			// 	[
			// 		'label' => __( 'Content Alignment', 'elementor-our-services-control' ),
			// 		'type' => \Elementor\Controls_Manager::CHOOSE,
			// 		'options' => [
			// 			'left' => [
			// 				'title' => __( 'Left', 'elementor-our-services-control' ),
			// 				'icon' => 'fa fa-align-left',
			// 			],
			// 			'center' => [
			// 				'title' => __( 'Center', 'elementor-our-services-control' ),
			// 				'icon' => 'fa fa-align-center',
			// 			],
			// 			'right' => [
			// 				'title' => __( 'Right', 'elementor-our-services-control' ),
			// 				'icon' => 'fa fa-align-right',
			// 			],
			// 		],
			// 		'default' => 'left',
			// 		'selectors' => [
			// 			'{{WRAPPER}} .our_services_section .box' => 'text-align: {{VALUE}};',
			// 		],
			// 	]
			// );
            
			$this->end_controls_section();
             //Background Control
            // $this->start_controls_section(
            //     'alignmentimage_section',
            //     [
            //         'label' => esc_html__( 'Image Alignment Setting', 'elementor-testimonial-control' ),
            //         'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            //     ]
            // );
            // $this->add_control(
			// 	'image_alignment',
			// 	[
			// 		'label' => __( 'Image Alignment', 'elementor-our-services-control' ),
			// 		'type' => \Elementor\Controls_Manager::CHOOSE,
			// 		'options' => [
			// 			'left' => [
			// 				'title' => __( 'Left', 'elementor-our-services-control' ),
			// 				'icon' => 'fa fa-align-left',
			// 			],
			// 			'center' => [
			// 				'title' => __( 'Center', 'elementor-our-services-control' ),
			// 				'icon' => 'fa fa-align-center',
			// 			],
			// 			'right' => [
			// 				'title' => __( 'Right', 'elementor-our-services-control' ),
			// 				'icon' => 'fa fa-align-right',
			// 			],
			// 		],
			// 		'default' => 'left',
			// 		'selectors' => [
			// 			'{{WRAPPER}} .our_services_section .box figure' => 'text-align: {{VALUE}};',
			// 		],
			// 	]
			// );
            // $this->end_controls_section();
	}
	/**
	 * Render our-services widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        //  var_dump($settings );
        $args = array(
            'post_type'=> 'our_services',
            'orderby'    => 'ID',
            'post_status' => 'publish',
            'order'    => 'ASC',
            'posts_per_page' => -1 // this will retrive all the post that is published 
            );
            $result = new WP_Query( $args );
        ?>
        <section class="our_services_section">
                <div class="row" data-aos="fade-up">
                <?php
                if ( $result-> have_posts() ) {
                    ?>
                        <div id="owl-demo" class="owl-carousel owl-theme">
                        <?php
                            while ( $result->have_posts() ){ 
                            $result->the_post();
                            $url = wp_get_attachment_url( get_post_thumbnail_id(), "thumbnail" );
                            $meta = get_post_meta(get_the_ID(),'post_thumbnail', true);
                            ?>
                            <div class="item">
                                <div class="box mb-0">
                                    <figure>
                                        <img src="<?php echo $meta ?>" alt="" class="img-fluid">
                                    </figure>
                                    <h3><?php echo get_the_title(); ?></h3>
                                    <p class="text-size-16"><?php echo wp_trim_words( get_the_content(), 19 ); ?></p>
                                    <div class="btn_wrapper">
                                        <a class="text-decoration-none" href="<?php echo get_post_permalink(); ?>">Read More<i class="fas fa-arrow-right"></i></a>
                                    </div>
                                </div>
                            </div>
                            <?php
                    }   
                ?>
                        </div>
                <?php
                    }  
                ?>
                </div>
        </section>
   <?php
		
	}

}
