<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor banner-sliders Widget.
 *
 * Elementor widget that uses the banner-sliders control.
 *
 * @since 1.0.0
 */
class Elementor_Banner_Sliders_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve banner-sliders widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'banner-sliders';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve banner-sliders widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blazin Banner slider', 'elementor-banner-sliders-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve banner-sliders widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register banner-sliders widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-banner-sliders-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_subheading', [
				'label' => __( 'SubHeading', 'elementor-banner-sliders-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'SubHeading' , 'elementor-banner-sliders-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_heading', [
				'label' => __( 'Heading', 'elementor-banner-sliders-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Heading' , 'elementor-banner-sliders-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'elementor-banner-sliders-control' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'List Content' , 'elementor-banner-sliders-control' ),
				'label_block' => true,
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'list_button_text_1',
			[
				'label' => esc_html__( 'Button Text 1', 'elementor-banner-sliders-control' ),
				'label_block' => true,
				'placeholder' => __( 'Order Now', 'elementor-banner-sliders-control' ),
				'default' => __( 'Order Now' , 'elementor-banner-sliders-control' ),
				'type' => 'text',
			]
		);
		$repeater->add_control(
			'list_button_link_1',
			[
				'label' => esc_html__( 'Button Link 1', 'elementor-banner-sliders-control' ),
				'label_block' => true,
				'placeholder' => __( '#', 'elementor-banner-sliders-control' ),
				'default' => __( '#' , 'elementor-banner-sliders-control' ),
				'type' => 'text',
			]
		);
		$repeater->add_control(
			'list_button_text_2',
			[
				'label' => esc_html__( 'Button Text 2', 'elementor-banner-sliders-control' ),
				'label_block' => true,
				'placeholder' => __( 'Order Now', 'elementor-banner-sliders-control' ),
				'default' => __( 'Order Now' , 'elementor-banner-sliders-control' ),
				'type' => 'text',
			]
		);
		$repeater->add_control(
			'list_button_link_2',
			[
				'label' => esc_html__( 'Button Link 2', 'elementor-banner-sliders-control' ),
				'label_block' => true,
				'placeholder' => __( '#', 'elementor-banner-sliders-control' ),
				'default' => __( '#' , 'elementor-banner-sliders-control' ),
				'type' => 'text',
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'elementor-banner-sliders-control' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_subheading' => __( 'SubHeading', 'elementor-banner-sliders-control' ),
						'list_heading' => __( 'Heading', 'elementor-banner-sliders-control' ),
						'list_content' => __( 'Content', 'elementor-banner-sliders-control' ),
						'list_button_text_1' => __( 'Button Text 1', 'elementor-banner-sliders-control' ),
						'list_button_link_1' => __( '#', 'elementor-banner-sliders-control' ),
						'list_button_text_2' => __( 'Button Text 1', 'elementor-banner-sliders-control' ),
						'list_button_link_2' => __( '#', 'elementor-banner-sliders-control' ),
					],
					[
						'list_subheading' => __( 'SubHeading', 'elementor-banner-sliders-control' ),
						'list_heading' => __( 'Heading', 'elementor-banner-sliders-control' ),
						'list_content' => __( 'Content', 'elementor-banner-sliders-control' ),
						'list_button_text_1' => __( 'Button Text 1', 'elementor-banner-sliders-control' ),
						'list_button_link_1' => __( '#', 'elementor-banner-sliders-control' ),
						'list_button_text_2' => __( 'Button Text 1', 'elementor-banner-sliders-control' ),
						'list_button_link_2' => __( '#', 'elementor-banner-sliders-control' ),
					],
				],
				'heading_field' => '{{{ list_heading }}}',
			]
		);
	}


	/**
	 * Render banner-sliders widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
		<section class="banner-section position-relative">
        <div class="align-middle text-center">
            <div class="container">
                <div id="carouselBannerControls" class="carousel slide" data-ride="carousel">
                    <div class="carousel-inner">
						<?php
						$count = 0;
						if ( $settings['list'] ) {
						foreach ( $settings['list'] as $item ) {	
							?>
                        <div class="carousel-item <?php if($count==0){echo 'active';}?>">
							<div class=" banner-section-content">
								<h6><?php echo $item['list_subheading']; ?></h6>
                        		<h1 data-aos="fade-up"><?php echo $item['list_heading']; ?></h1>
                        		<p class="text-white" data-aos="fade-right"><?php echo $item['list_content']; ?></p>
                        		<div class="btn_wrapper" data-aos="fade-up">
                            		<a class="text-decoration-none default-btn hover-effect contactus_btn" href="<?php echo $item['list_button_link_1']; ?>"><?php echo $item['list_button_text_1']; ?><i class="fas fa-arrow-right"></i></a>
                            		<a class="text-decoration-none default-btn hover-effect readmore_btn" href="<?php echo $item['list_button_link_2']; ?>"><?php echo $item['list_button_text_2']; ?><i class="fas fa-arrow-right"></i></a>
                        		</div>
							</div>
                        </div>
						<?php
						$count++;
					}
					}
					?>
                    </div>
					<ul class="carousel-indicators">
					<?php
						$count = 0;
						if ( $settings['list'] ) {
							foreach ( $settings['list'] as $item ) {	
						?>	
							<li data-target="#carouselBannerControls" data-slide-to="<?=$count?>" class="<?php if($count==0){echo 'active';} ?>"></li>
						<?php
						$count++;
							}
						}
						?>
					</ul>
                </div>
            </div>
        </div>
    </section>
        <?php
	}

}