<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor testimonial Widget.
 *
 * Elementor widget that uses the testimonial control.
 *
 * @since 1.0.0
 */
class Elementor_Testimonial_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve testimonial widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'testimonial';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve testimonial widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blazin Testimonial', 'elementor-testimonial-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve testimonial widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register testimonial widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-testimonial-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_clientname', [
				'label' => __( 'clientname', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'clientname' , 'elementor-testimonial-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_content', [
				'label' => __( 'Duis aute irure dolor in reprehender
				voluptate velit esse cillum dolore fugiat 
				nulla pariatur sint occaecat cupidata
				non proident, sunt in culpa aui office
				deserunt mollit anim laborum.', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'Duis aute irure dolor in reprehender
				voluptate velit esse cillum dolore fugiat 
				nulla pariatur sint occaecat cupidata
				non proident, sunt in culpa aui office
				deserunt mollit anim laborum.' , 'elementor-testimonial-control' ),
				'label_block' => true,
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'list_department',
			[
				'label' => esc_html__( 'client Department', 'elementor-testimonial-control' ),
				'label_block' => true,
				'placeholder' => __( 'Hr', 'elementor-testimonial-control' ),
				'default' => __( 'Hr' , 'elementor-testimonial-control' ),
				'type' => 'text',
			]
		);
		$repeater->add_control(
			'list_image',
			[
				'label' => esc_html__( 'Client image', 'elementor-testimonial-04-control' ),
				'label_block' => true,
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => PLUGIN_BASE_URI. 'assets/images/testimonial-image.png' ,
				],
			]
		);
        $repeater->add_control(
			'list_image1',
			[
				'label' => esc_html__( 'Quote Icon', 'elementor-testimonial-04-control' ),
				'label_block' => true,
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => PLUGIN_BASE_URI. 'assets/images/testimonial-comas.png' ,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Testimonial List', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						
						'list_clientname' => __( 'Client Name', 'elementor-testimonial-control' ),
						'list_content' => __( 'Duis aute irure dolor in reprehender
						voluptate velit esse cillum dolore fugiat 
						nulla pariatur sint occaecat cupidata
						non proident, sunt in culpa aui office
						deserunt mollit anim laborum.', 'elementor-testimonial-control' ),
						'list_department' => __( 'Department Name', 'elementor-testimonial-control' ),
						'list_image' => __( 'image', 'elementor-testimonial-control' ),
                        'list_image1' => __( 'image1', 'elementor-testimonial-control' ),
					],
					[
						
						'list_clientname' => __( 'Client Name', 'elementor-testimonial-control' ),
						'list_content' => __( 'Duis aute irure dolor in reprehender
						voluptate velit esse cillum dolore fugiat 
						nulla pariatur sint occaecat cupidata
						non proident, sunt in culpa aui office
						deserunt mollit anim laborum.', 'elementor-testimonial-control' ),
						'list_department' => __( 'Department Name', 'elementor-testimonial-control' ),
						'list_image' => __( 'image', 'elementor-testimonial-control' ),
                        'list_image1' => __( 'image1', 'elementor-testimonial-control' ),

					],
				],
				'heading_field' => '{{{ list_heading }}}',
			]
		);
		$this->end_controls_section();
		//Color Control
		$this->start_controls_section(
			'color_section',
			[
				'label' => esc_html__( 'Color', 'elementor-testimonial-control' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Content Color', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'padding1',
			[
				'label' => esc_html__( 'Padding', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .text-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'text_color1',
			[
				'label' => esc_html__( 'Client Name Color', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .name' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'text_color2',
			[
				'label' => esc_html__( 'Department Name Color', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .designation' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'padding2',
			[
				'label' => esc_html__( 'Padding', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		//Responsive Control
		$this->start_controls_section(
			'responsive_section',
			[
				'label' => esc_html__( 'Responsive', 'elementor-testimonial-control' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'padding3',
			[
				'label' => esc_html__( 'Padding', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .testimonials-section .testimonial-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'margin',
			[
				'label' => esc_html__( 'Margin', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .testimonials-section .testimonial-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment', 'elementor-testimonial-control' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-testimonial-control' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .text-content'   => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		//Background Control
		$this->start_controls_section(
			'background_section',
			[
				'label' => esc_html__( 'Background', 'elementor-testimonial-control' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .testimonials-section .testimonial-box',
			]
		);
		$this->end_controls_section();
}


	/**
	 * Render testimonial widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
	<section class="testimonials-section position-relative" id="testimonials">
			<div class="row position-relative" data-aos="fade-up">
				<div class="owl-carousel owl-theme">
					<?php
						$count = 0;
						if ( $settings['list'] ) {
						foreach ( $settings['list'] as $item ) {	
					?>
					<div class="item">
						<div class="testimonial-box float-left w-100">
							<ul class="list-unstyled">
								<li><i class="eicon-star active"></i></li>
								<li><i class="eicon-star active"></i></li>
								<li><i class="eicon-star active"></i></li>
								<li><i class="eicon-star active"></i></li>
								<li><i class="eicon-star active"></i></li>
							</ul>
							<div class="text-content">
								<p ><?php echo $item['list_content'];?></p>
							</div>
							<div class="info position-relative">
								<div class="image_wrapper">
									<figure class="user-img mb-0">
										<?php
											if( isset($item['list_image']['id']) && !empty( $item['list_image']['id'] ) ){
										?>
                                        <?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
										<?php
										}
										else {
										?>
											<img src="<?php echo PLUGIN_BASE_URI. 'assets/images/testimonials.png' ?>" alt="">
										<?php
											}
										?>
									</figure>
								</div>
								<div class="designation-outer">
									<p class="name mb-0"><?php echo $item['list_clientname']; ?></p>
									<p class="designation mb-0"><?php echo $item['list_department']; ?></p>
								</div>
								<figure class="quote-img position-absolute mb-0">
										<?php
											if( isset($item['list_image']['id']) && !empty( $item['list_image1']['id'] ) ){
										?>
                                        	<?php echo wp_get_attachment_image( $item['list_image1']['id'], 'full' ); ?>
										<?php
										}
										else {
										?>
											<img src="<?php echo PLUGIN_BASE_URI. 'assets/images/quote_icon.png' ?>" alt="">
										<?php
											}
										?>
								</figure>
							</div>
						</div>
					</div>
						<?php
							$count++;
						}
						}
						?>
				</div>
			</div>
		</section> 
        <?php
	}

}