<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor staff Widget.
 *
 * Elementor widget that uses the staff control.
 *
 * @since 1.0.0
 */
class Elementor_Staff_Box_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve staff widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'staff-box';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve staff widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blazin Staff Box', 'elementor-staff-box-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve staff widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	// public function get_icon() {
	// 	return 'eicon-carousel-loop';
	// }

	/**
	 * Register staff widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-staff-box-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_name', [
				'label' => __( 'Staff Name', 'elementor-staff-box-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Name' , 'elementor-staff-box-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_department', [
				'label' => __( 'Staff Destination', 'elementor-staff-box-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Destination' , 'elementor-staff-box-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_button_link_1',
			[
				'label' => esc_html__( 'Facebook Link', 'elementor-staff-box-control' ),
				'label_block' => true,
				'placeholder' => __( '#', 'elementor-staff-box-control' ),
				'default' => __( '#' , 'elementor-staff-box-control' ),
				'type' => 'text',
			]
		);
		$repeater->add_control(
			'list_button_link_2',
			[
				'label' => esc_html__( 'Twitter Link', 'elementor-staff-box-control' ),
				'label_block' => true,
				'placeholder' => __( '#', 'elementor-staff-box-control' ),
				'default' => __( '#' , 'elementor-staff-box-control' ),
				'type' => 'text',
			]
		);
		$repeater->add_control(
			'list_button_link_3',
			[
				'label' => esc_html__( 'Instagram Link', 'elementor-staff-box-control' ),
				'label_block' => true,
				'placeholder' => __( '#', 'elementor-staff-box-control' ),
				'default' => __( '#' , 'elementor-staff-box-control' ),
				'type' => 'text',
			]
		);
        $repeater->add_control(
			'list_image',
			[
				'label' => esc_html__( 'Client image', 'elementor-staff-box-control' ),
				'label_block' => true,
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => PLUGIN_BASE_URI. 'assets/images/staff_1.png' ,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'elementor-staff-box-control' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_name' => __( 'Staff Name', 'elementor-staff-box-control' ),
						'list_department' => __( 'Staff Destination', 'elementor-staff-box-control' ),
						'list_image' => __( 'Client image', 'elementor-staff-box-control' ),
						'list_button_link_1' => __( '#', 'elementor-staff-box-control' ),
						'list_button_link_2' => __( '#', 'elementor-staff-box-control' ),
						'list_button_link_3' => __( '#', 'elementor-staff-box-control' ),
					],
					[
						'list_name' => __( 'Staff Name', 'elementor-staff-box-control' ),
						'list_department' => __( 'Staff Destination', 'elementor-staff-box-control' ),
                        'list_image' => __( 'Client image', 'elementor-staff-box-control' ),
						'list_button_link_1' => __( '#', 'elementor-staff-box-control' ),
						'list_button_link_2' => __( '#', 'elementor-staff-box-control' ),
						'list_button_link_3' => __( '#', 'elementor-staff-box-control' ),
					],
				],
				'heading_field' => '{{{ list_heading }}}',
			]
		);
        $this->end_controls_section();
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Content', 'elementor-staff-box-control' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( 'Title Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography1',
				'selector' => '{{WRAPPER}} h3',
			]
		);
        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__( 'Alignment', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'textdomain' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'textdomain' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'textdomain' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} h3'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'text_color1',
            [
                'label' => esc_html__( 'Text Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} p' => 'color: {{VALUE}}',
                ],
            ]
        );$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_text',
				'selector' => '{{WRAPPER}} p',
			]
		);
        $this->add_responsive_control(
            'content_align',
            [
                'label' => esc_html__( 'Alignment', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'textdomain' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'textdomain' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'textdomain' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} p'   => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__( 'Padding', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .our_staff_section .staff_box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background2',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .our_staff_section .staff_box',
			]
		);
        $this->end_controls_section();
        //Background Control
		$this->start_controls_section(
			'background_section',
			[
				'label' => esc_html__( 'Background Overlay', 'elementor-staff-box-control' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background3',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .our_staff_section .staff_box:hover',
			]
		);
		$this->end_controls_section();
	}


	/**
	 * Render staff widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        
        ?>
    <!-- OUR STAFF SECTION -->
        <section class="our_staff_section team_staff_section">
                <!-- <div class="row" data-aos="fade-up"> -->
                    <?php
                        echo '<div class="row" data-aos="fade-up">';
                        $count = 0;
                        if ( $settings['list'] ) {
                        foreach ( $settings['list'] as $item ) {	
                    ?>
                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                        <div class="staff_box text-center">
                            <div class="image_wrapper position-relative">
                                <figure>
                                    <?php
                                        if( isset($item['list_image']['id']) && !empty( $item['list_image']['id'] ) ){
                                    ?>
                                    <?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
                                    <?php
                                    }
                                    else {
                                    ?>
                                        <img src="<?php echo PLUGIN_BASE_URI. 'assets/images/staff_1.jpg' ?>" alt="">
                                    <?php
                                        }
                                    ?>
                                </figure>
                                <div class="icons float-left d-table">
                                    <div class="icons_wrapper d-table-cell align-middle">
                                        <ul class="m-0 position-absolute p-0">
                                            <li class="list-unstyled d-inline-block"><a class="hover-effect d-inline-block" href="<?php echo $item['list_button_link_1'];?>"><i class="fa-brands fa-facebook-f"></i></a></li>
                                            <li class="list-unstyled d-inline-block"><a class="hover-effect d-inline-block" href="<?php echo $item['list_button_link_2'];?>"><i class="fa-brands fa-twitter"></i></a></li>
                                            <li class="list-unstyled d-inline-block"><a class="hover-effect d-inline-block" href="<?php echo $item['list_button_link_3'];?>"><i class="fa-brands fa-instagram"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <a href="#" class="text-decoration-none">
                                <h3 class="mb-0"><?php echo $item['list_name'];?></h3>
                                <p class="mb-0 text-size-16"><?php echo $item['list_department'];?></p>
                            </a>
                        </div>
                    </div>
                    <?php
                        $count++;
                        if ($count % 3 == 0) {
                        echo '</div><div class="row">';
                    }
                    }
                    echo '</div>';
                    ?>
                <!-- </div> -->
        </section>
        <!-- WHO WE ARE SECTION -->
        <?php
	}

}
}